
	frame imagetraceadvanced;

	frame imagetraceframe {
		title "Easytrace Settings";
		right top source;
		
		radiobutton featuretype;
		radiobutton tracemode1;
		radiobutton tracemode2;
		checkbox autoapply;
		checkbox usesametemplate;
		button advancedsetting;
		
		checkbox smarttrace {
			title right center "Easy Tracing";
			info "Digitize image smartly.";
			geometry 2, 6, 110, 26;
			lock top, left, width, height;
			on valuechanged {
				if ($autoapply)
					ApplyTraceSettings();
				if ($smarttrace) {
					enable featuretype;
					enable tracemode1;
					enable tracemode2;
					enable usesametemplate;
					enable advancedsetting;
				}
				else {
					disable featuretype;
					disable tracemode1;
					disable tracemode2;
					disable usesametemplate;
					disable advancedsetting;
				}
			}
		}
		
		radiobutton featuretype {
			title "Feature Type:";
			info "Specify the type of features to be digitized";
			geometry 2, 38, 110, 90;
			lock top, left, width, height;
			options { 
				"Boundary",
				"Centerline",
				"Ribbon"
			};
			titlelist {
				"Boundary",
				"Centerline",
				"Ribbon"
			};
			layout vertical;
			on valuechanged {
				if ($featuretype == "Boundary") {
					hide tracemode2;
					show tracemode1;
					hide usesametemplate;
				}
				else {
					hide tracemode1;
					show tracemode2;
					show usesametemplate;
				}
				if ($autoapply)
					ApplyTraceSettings();
			}
		}
		
		radiobutton tracemode1 {
			title "Tracing Mode:";
			info "Specify the tracing mode - Rubber Banding, Discrete, Streaming, or Manual";
			geometry 2, 131, 114, 115;
			lock top, left, width, height;
			options { 
				"Rubber Banding",
				"Discrete",
				"Streaming",
				"Manual"
			};
			titlelist {
				"Rubber Band (A)",
				"Discrete (D)",
				"Streaming (S)",
				"Manual (Shift)"
			};
			layout vertical;
			on valuechanged {
				if ($autoapply)
					ApplyTraceSettings();
			}
		}
		
		radiobutton tracemode2 {
			title "Tracing Mode:";
			info "Specify the tracing mode - Rubber Banding, Discrete, or Manual";
			geometry 2, 131, 114, 90;
			lock top, left, width, height;
			options { 
				"Rubber Banding",
				"Discrete",
				"Manual"
			};
			titlelist {
				"Rubber Band (A)",
				"Discrete (D)",
				"Manual (Shift)"
			};
			layout vertical;
			on valuechanged {
				if ($autoapply)
					ApplyTraceSettings();
			}
		}
		
		checkbox usesametemplate {
			title right center "Reuse Temp.";
			info "Use previously specified template if available";
			geometry 2, 226, 112, 26;
			lock top, left, width, height;
			on valuechanged {
				if ($autoapply)
					ApplyTraceSettings();
			}
		}
		button advancedsetting {
			title "Advan. Settings...";
			geometry 2,259,114,25;
			lock right, bottom, width, height;
			info "Display the Advanced Settings dialog box";
			on mousedown {
				display imagetraceadvanced;
			}
		}
		
		checkbox autoapply {
			title right center "Auto Apply Changes";
			info "Apply The Setting Changes Automatically";
			geometry 2,205,106,25;
			value 1;
		}
		
		button cancelbutton {
			title "Close";
			geometry 3,290,50,25;
			lock right, bottom, width, height;
			info "Cancel the un-applied setting changes and close the dialog box";
			on mousedown {
				undisplay imagetraceframe;
			}
		}

		button helpbutton {
			title "Help";
			geometry 63,290,50,25;
			lock right, bottom, width, height;
			info "Help for Sensor Info Tool";
			on mousedown showhelp;
		}
		
		on framedisplay {
			hide autoapply;
		    set autoapply = 0;
			set smarttrace = edis_GetSmartTracing();
			set featuretype = edis_GetFeatureType();
			set usesametemplate = edis_GetUseSameTemplate();
			if (edis_EasyTraceLicenseAvailable() == 0 )
			{
				set smarttrace = 0;
				disable smarttrace;
				undisplay imagetraceframe;
			}
			else
			{
				if ($featuretype == "Boundary") {
					set tracemode1 = edis_GetTraceMode();
					hide tracemode2;
					show tracemode1;
					hide usesametemplate;
				}
				else {
					set tracemode2 = edis_GetTraceMode();
					hide tracemode1;
					show tracemode2;
					show usesametemplate;
				}
				if ($smarttrace) {
					enable featuretype;
					enable tracemode1;
					enable tracemode2;
					enable usesametemplate;
					enable advancedsetting;
				}
				else {
					disable featuretype;
					disable tracemode1;
					disable tracemode2;
					disable usesametemplate;
					disable advancedsetting;
				}
				set autoapply = 1;
			}
		}
		
		on ApplyTraceSettings {
			if ($featuretype == "Boundary")
				edis_setimagetracesettings($smarttrace, $featuretype, $tracemode1, $usesametemplate);
			else
				edis_setimagetracesettings($smarttrace, $featuretype, $tracemode2, $usesametemplate);
		}
	}
	
	frame imagetraceadvanced {
		title "Advanced Easytrace Settings";
		center source;
		modal;
		
		group weightingfactors {
			title "Weighting Factors";
			geometry 5, 10, 300, 120;
			
			meternumber smoothness {
				info "Adjust smoothness slider";
				geometry 5,5, 290, 25;
				title "Smoothness";
				titleoffset 90 noalign;
				format "3.0";
				size 13,2;
				value 50;
				min 0;
				max 100;
			}
			meternumber straightness {
				info "Adjust straightness slider";
				title "Straightness";
				titleoffset 90 noalign;
				geometry 5,35, 290, 25;
				format "3.0";
				size 13,2;
				value 50;
				min 0;
				max 100;
			}
			meternumber imagefeature {
				info "Adjust image feature slider";
				title "Image Feature";
				titleoffset 90 noalign;
				geometry 5,65, 290, 25;
				format "3.0";
				size 13,2;
				value 50;
				min 0;
				max 100;
			}
		}
		
		label colorbandlabel {
			geometry 5, 140, 280, 25;
			value "Color Band For Easy Tracing:";
			info "Specify the color band used in Easytrace algorithm";
		}
		radiobutton colorband {
			title "";
			info "Specify the color band to be used in Easytrace algorithm";
			geometry 5, 165, 300, 30;
			lock top, left, width, height;
			layout horizontal;
			options {
				"All", 
				"Red",
				"Green",
				"Blue"
			};
			titlelist {
				"All",
				"Red",
				"Green",
				"Blue"
			};
		}
		textnumber generalizetolerance {
			title left center "Generalization Tolerance (in pixels):";
			titleoffset 220 noalign;
			geometry 5,200,300,25;
			format "6.3";
			min 0;
			max 100;
			info "Generalization tolerance in screen pixels. The bigger the value, the straighter the final result.";
		}

		button okbutton {
			title "OK";
			geometry 25,234,60,25;
			lock right, bottom, width, height;
			info "Use the seetings and close the window";
			on mousedown {
				edis_ApplyAdvancedImageTracingSettings(
					$smoothness, $straightness, $imagefeature,
					$generalizetolerance, $colorband);
				undisplay imagetraceadvanced;
			}
		}

		button cancelbutton {
			title "Cancel";
			geometry 95,234,60,25;
			lock right, bottom, width, height;
			info "Cancel the setting changes and close dialog";
			on mousedown {
				undisplay imagetraceadvanced;
			}
		}

		button resetbutton {
			title "Reset";
			geometry 165,234,60,25;
			lock right, bottom, width, height;
			info "Reset all fields to their default values";
			on mousedown {
				set smoothness = 50;
				set straightness = 50;
				set imagefeature = 50;
				set generalizetolerance = 1.0;
				set colorband = "All";
			}
		}

		button helpbutton {
			title "Help";
			geometry 235,234,60,25;
			lock right, bottom, width, height;
			info "Help for Advanced Easytrace Settings dialog box";
			on mousedown showhelp;
		}
		on framedisplay {
			set smoothness = edis_GetSmartTracingSmoothnessFactor();
			set straightness = edis_GetSmartTracingStraightnessFactor();
			set imagefeature = edis_GetSmartTracingImageFeatureFactor();
			set generalizetolerance = edis_GetSmartTracingGeneralizeToleranceFactor();
			set colorband = edis_GetSmartTracingColorBand();
		}
	}
